/* USER CODE BEGIN Header */
/**
 ******************************************************************************
 * @file           : main.c
 * @brief          : Main program body
 ******************************************************************************
 * @attention
 *
 * Copyright (c) 2025 STMicroelectronics.
 * All rights reserved.
 *
 * This software is licensed under terms that can be found in the LICENSE file
 * in the root directory of this software component.
 * If no LICENSE file comes with this software, it is provided AS-IS.
 *
 ******************************************************************************
 */
/* USER CODE END Header */
/* Includes ------------------------------------------------------------------*/
#include "main.h"

/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */

/* USER CODE END Includes */

/* Private typedef -----------------------------------------------------------*/
/* USER CODE BEGIN PTD */

/* USER CODE END PTD */

/* Private define ------------------------------------------------------------*/
/* USER CODE BEGIN PD */
#define RED_LED_PIN GPIO_PIN_0
#define ORANGE_LED_PIN GPIO_PIN_1
#define YELLOW_LED_PIN GPIO_PIN_2
#define CYAN_LED_PIN GPIO_PIN_3
#define BLUE_LED_PIN GPIO_PIN_4

#define LED_PORT GPIOA
#define REGULAR_LEDS (RED_LED_PIN | ORANGE_LED_PIN | YELLOW_LED_PIN)

#define BLUE_LED_BRIGHTNESS 20
#define CYAN_LED_BRIGHTNESS 5
/* USER CODE END PD */

/* Private macro -------------------------------------------------------------*/
/* USER CODE BEGIN PM */

/* USER CODE END PM */

/* Private variables ---------------------------------------------------------*/
TIM_HandleTypeDef htim14;

/* USER CODE BEGIN PV */

/* USER CODE END PV */

/* Private function prototypes -----------------------------------------------*/
void SystemClock_Config(void);
static void MX_GPIO_Init(void);
static void MX_TIM14_Init(void);
/* USER CODE BEGIN PFP */
void delay_ms(uint32_t ms) {
	HAL_Delay(ms);
}

void Software_PWM_Delay(void) {
	for (volatile uint16_t i = 0; i < 10; i++);
}

void Blue_LED_Set(uint8_t state) {
	if (state) {
		__HAL_TIM_SET_COMPARE(&htim14, TIM_CHANNEL_1, BLUE_LED_BRIGHTNESS);
	} else {
		__HAL_TIM_SET_COMPARE(&htim14, TIM_CHANNEL_1, 0);
	}
}

void Cyan_LED_Dimmed_Delay(uint32_t ms) {
	uint32_t end_time = HAL_GetTick() + ms;

	while (HAL_GetTick() < end_time) {
		HAL_GPIO_WritePin(LED_PORT, CYAN_LED_PIN, GPIO_PIN_SET);
		for (uint8_t i = 0; i < CYAN_LED_BRIGHTNESS; i++) {
			Software_PWM_Delay();
		}

		HAL_GPIO_WritePin(LED_PORT, CYAN_LED_PIN, GPIO_PIN_RESET);
		for (uint8_t i = 0; i < (100 - CYAN_LED_BRIGHTNESS); i++) {
			Software_PWM_Delay();
		}
	}
}

void Cyan_LED_Set(uint8_t state) {
	if (state) {
		HAL_GPIO_WritePin(LED_PORT, CYAN_LED_PIN, GPIO_PIN_SET);
		for (uint8_t i = 0; i < CYAN_LED_BRIGHTNESS; i++) {
			Software_PWM_Delay();
		}

		HAL_GPIO_WritePin(LED_PORT, CYAN_LED_PIN, GPIO_PIN_RESET);
		for (uint8_t i = 0; i < (100 - CYAN_LED_BRIGHTNESS); i++) {
			Software_PWM_Delay();
		}
	} else {
		HAL_GPIO_WritePin(LED_PORT, CYAN_LED_PIN, GPIO_PIN_RESET);
	}
}
/* USER CODE END PFP */

/* Private user code ---------------------------------------------------------*/
/* USER CODE BEGIN 0 */

/* USER CODE END 0 */

/**
  * @brief  The application entry point.
  * @retval int
  */
int main(void)
{

  /* USER CODE BEGIN 1 */

  /* USER CODE END 1 */

  /* MCU Configuration--------------------------------------------------------*/

  /* Reset of all peripherals, Initializes the Flash interface and the Systick. */
  HAL_Init();

  /* USER CODE BEGIN Init */

  /* USER CODE END Init */

  /* Configure the system clock */
  SystemClock_Config();

  /* USER CODE BEGIN SysInit */

  /* USER CODE END SysInit */

  /* Initialize all configured peripherals */
  MX_GPIO_Init();
  MX_TIM14_Init();
  /* USER CODE BEGIN 2 */
	HAL_TIM_PWM_Start(&htim14, TIM_CHANNEL_1);
  /* USER CODE END 2 */

  /* Infinite loop */
  /* USER CODE BEGIN WHILE */
	while (1) {
		for (int i = 0; i < 3; i++) {
			HAL_GPIO_WritePin(LED_PORT, RED_LED_PIN, GPIO_PIN_SET);
			delay_ms(200);
			HAL_GPIO_WritePin(LED_PORT, RED_LED_PIN, GPIO_PIN_RESET);

			HAL_GPIO_WritePin(LED_PORT, ORANGE_LED_PIN, GPIO_PIN_SET);
			delay_ms(200);
			HAL_GPIO_WritePin(LED_PORT, ORANGE_LED_PIN, GPIO_PIN_RESET);

			HAL_GPIO_WritePin(LED_PORT, YELLOW_LED_PIN, GPIO_PIN_SET);
			delay_ms(200);
			HAL_GPIO_WritePin(LED_PORT, YELLOW_LED_PIN, GPIO_PIN_RESET);

			Cyan_LED_Dimmed_Delay(200);

			Blue_LED_Set(1);
			delay_ms(200);
			Blue_LED_Set(0);
		}

		for (int i = 0; i < 5; i++) {
			HAL_GPIO_WritePin(LED_PORT,
			RED_LED_PIN | ORANGE_LED_PIN | YELLOW_LED_PIN, GPIO_PIN_SET);
			Blue_LED_Set(1);

			Cyan_LED_Dimmed_Delay(300);

			HAL_GPIO_WritePin(LED_PORT,
			RED_LED_PIN | ORANGE_LED_PIN | YELLOW_LED_PIN, GPIO_PIN_RESET);
			Blue_LED_Set(0);
			delay_ms(300);
		}

		for (int i = 0; i < 5; i++) {
			HAL_GPIO_WritePin(LED_PORT, RED_LED_PIN | YELLOW_LED_PIN,
					GPIO_PIN_SET);
			HAL_GPIO_WritePin(LED_PORT, ORANGE_LED_PIN | CYAN_LED_PIN,
					GPIO_PIN_RESET);
			Blue_LED_Set(1);
			delay_ms(250);

			HAL_GPIO_WritePin(LED_PORT, RED_LED_PIN | YELLOW_LED_PIN,
					GPIO_PIN_RESET);
			HAL_GPIO_WritePin(LED_PORT, ORANGE_LED_PIN, GPIO_PIN_SET);
			Blue_LED_Set(0);

			uint32_t end_time = HAL_GetTick() + 250;
			while (HAL_GetTick() < end_time) {
				HAL_GPIO_WritePin(LED_PORT, CYAN_LED_PIN, GPIO_PIN_SET);
				for (uint8_t j = 0; j < CYAN_LED_BRIGHTNESS; j++) {
					Software_PWM_Delay();
				}

				HAL_GPIO_WritePin(LED_PORT, CYAN_LED_PIN, GPIO_PIN_RESET);
				for (uint8_t j = 0; j < (100 - CYAN_LED_BRIGHTNESS); j++) {
					Software_PWM_Delay();
				}
			}
		}
		HAL_GPIO_WritePin(LED_PORT,
		RED_LED_PIN | ORANGE_LED_PIN | YELLOW_LED_PIN | CYAN_LED_PIN,
				GPIO_PIN_RESET);
		Blue_LED_Set(0);

		HAL_GPIO_WritePin(LED_PORT, RED_LED_PIN, GPIO_PIN_SET);
		delay_ms(150);
		HAL_GPIO_WritePin(LED_PORT, ORANGE_LED_PIN, GPIO_PIN_SET);
		delay_ms(150);
		HAL_GPIO_WritePin(LED_PORT, YELLOW_LED_PIN, GPIO_PIN_SET);
		delay_ms(150);

		uint32_t start_time = HAL_GetTick();
		uint32_t cyan_only_period = 150;

		while (HAL_GetTick() < start_time + cyan_only_period) {
		    HAL_GPIO_WritePin(LED_PORT, CYAN_LED_PIN, GPIO_PIN_SET);
		    for (uint8_t j = 0; j < CYAN_LED_BRIGHTNESS; j++) {
		        Software_PWM_Delay();
		    }

		    HAL_GPIO_WritePin(LED_PORT, CYAN_LED_PIN, GPIO_PIN_RESET);
		    for (uint8_t j = 0; j < (100 - CYAN_LED_BRIGHTNESS); j++) {
		        Software_PWM_Delay();
		    }
		}

		Blue_LED_Set(1);
		start_time = HAL_GetTick();
		uint32_t blue_on_period = 150;

		while (HAL_GetTick() < start_time + blue_on_period) {
		    HAL_GPIO_WritePin(LED_PORT, CYAN_LED_PIN, GPIO_PIN_SET);
		    for (uint8_t j = 0; j < CYAN_LED_BRIGHTNESS; j++) {
		        Software_PWM_Delay();
		    }

		    HAL_GPIO_WritePin(LED_PORT, CYAN_LED_PIN, GPIO_PIN_RESET);
		    for (uint8_t j = 0; j < (100 - CYAN_LED_BRIGHTNESS); j++) {
		        Software_PWM_Delay();
		    }
		}

		Blue_LED_Set(0);

		start_time = HAL_GetTick();
		uint32_t cyan_final_period = 150;

		while (HAL_GetTick() < start_time + cyan_final_period) {
		    HAL_GPIO_WritePin(LED_PORT, CYAN_LED_PIN, GPIO_PIN_SET);
		    for (uint8_t j = 0; j < CYAN_LED_BRIGHTNESS; j++) {
		        Software_PWM_Delay();
		    }

		    HAL_GPIO_WritePin(LED_PORT, CYAN_LED_PIN, GPIO_PIN_RESET);
		    for (uint8_t j = 0; j < (100 - CYAN_LED_BRIGHTNESS); j++) {
		        Software_PWM_Delay();
		    }
		}
		delay_ms(150);

		HAL_GPIO_WritePin(LED_PORT, YELLOW_LED_PIN, GPIO_PIN_RESET);
		delay_ms(150);
		HAL_GPIO_WritePin(LED_PORT, ORANGE_LED_PIN, GPIO_PIN_RESET);
		delay_ms(150);
		HAL_GPIO_WritePin(LED_PORT, RED_LED_PIN, GPIO_PIN_RESET);
		delay_ms(150);

		for (int i = 0; i < 3; i++) {
			for (uint16_t led = RED_LED_PIN; led <= CYAN_LED_PIN; led <<= 1) {
				if (led == CYAN_LED_PIN) {
					Cyan_LED_Dimmed_Delay(100);
				} else {
					HAL_GPIO_WritePin(LED_PORT, led, GPIO_PIN_SET);
					delay_ms(100);
					HAL_GPIO_WritePin(LED_PORT, led, GPIO_PIN_RESET);
				}
			}

			Blue_LED_Set(1);
			delay_ms(100);
			Blue_LED_Set(0);

			for (uint16_t led = CYAN_LED_PIN; led >= RED_LED_PIN; led >>= 1) {
				if (led == CYAN_LED_PIN) {
					Cyan_LED_Dimmed_Delay(100);
				} else {
					HAL_GPIO_WritePin(LED_PORT, led, GPIO_PIN_SET);
					delay_ms(100);
					HAL_GPIO_WritePin(LED_PORT, led, GPIO_PIN_RESET);
				}
			}
		}

		for (int i = 0; i < 3; i++) {
			HAL_GPIO_WritePin(LED_PORT, RED_LED_PIN, GPIO_PIN_SET);
			delay_ms(100);
			HAL_GPIO_WritePin(LED_PORT, RED_LED_PIN, GPIO_PIN_RESET);
			delay_ms(100);
		}
		delay_ms(200);

		for (int i = 0; i < 3; i++) {
			HAL_GPIO_WritePin(LED_PORT, ORANGE_LED_PIN, GPIO_PIN_SET);
			delay_ms(100);
			HAL_GPIO_WritePin(LED_PORT, ORANGE_LED_PIN, GPIO_PIN_RESET);
			delay_ms(100);
		}
		delay_ms(200);

		for (int i = 0; i < 3; i++) {
			HAL_GPIO_WritePin(LED_PORT, YELLOW_LED_PIN, GPIO_PIN_SET);
			delay_ms(100);
			HAL_GPIO_WritePin(LED_PORT, YELLOW_LED_PIN, GPIO_PIN_RESET);
			delay_ms(100);
		}
		delay_ms(200);

		for (int i = 0; i < 3; i++) {
			Cyan_LED_Dimmed_Delay(100);
			delay_ms(100);
		}
		delay_ms(200);

		for (int i = 0; i < 3; i++) {
			Blue_LED_Set(1);
			delay_ms(100);
			Blue_LED_Set(0);
			delay_ms(100);
		}
		delay_ms(200);

    /* USER CODE END WHILE */

    /* USER CODE BEGIN 3 */
	}
  /* USER CODE END 3 */
}

/**
  * @brief System Clock Configuration
  * @retval None
  */
void SystemClock_Config(void)
{
  RCC_OscInitTypeDef RCC_OscInitStruct = {0};
  RCC_ClkInitTypeDef RCC_ClkInitStruct = {0};

  /** Initializes the RCC Oscillators according to the specified parameters
  * in the RCC_OscInitTypeDef structure.
  */
  RCC_OscInitStruct.OscillatorType = RCC_OSCILLATORTYPE_HSE;
  RCC_OscInitStruct.HSEState = RCC_HSE_ON;
  RCC_OscInitStruct.PLL.PLLState = RCC_PLL_ON;
  RCC_OscInitStruct.PLL.PLLSource = RCC_PLLSOURCE_HSE;
  RCC_OscInitStruct.PLL.PLLMUL = RCC_PLL_MUL6;
  RCC_OscInitStruct.PLL.PREDIV = RCC_PREDIV_DIV1;
  if (HAL_RCC_OscConfig(&RCC_OscInitStruct) != HAL_OK)
  {
    Error_Handler();
  }

  /** Initializes the CPU, AHB and APB buses clocks
  */
  RCC_ClkInitStruct.ClockType = RCC_CLOCKTYPE_HCLK|RCC_CLOCKTYPE_SYSCLK
                              |RCC_CLOCKTYPE_PCLK1;
  RCC_ClkInitStruct.SYSCLKSource = RCC_SYSCLKSOURCE_PLLCLK;
  RCC_ClkInitStruct.AHBCLKDivider = RCC_SYSCLK_DIV1;
  RCC_ClkInitStruct.APB1CLKDivider = RCC_HCLK_DIV1;

  if (HAL_RCC_ClockConfig(&RCC_ClkInitStruct, FLASH_LATENCY_1) != HAL_OK)
  {
    Error_Handler();
  }
}

/**
  * @brief TIM14 Initialization Function
  * @param None
  * @retval None
  */
static void MX_TIM14_Init(void)
{

  /* USER CODE BEGIN TIM14_Init 0 */

  /* USER CODE END TIM14_Init 0 */

  TIM_OC_InitTypeDef sConfigOC = {0};

  /* USER CODE BEGIN TIM14_Init 1 */

  /* USER CODE END TIM14_Init 1 */
  htim14.Instance = TIM14;
  htim14.Init.Prescaler = 47;
  htim14.Init.CounterMode = TIM_COUNTERMODE_UP;
  htim14.Init.Period = 99;
  htim14.Init.ClockDivision = TIM_CLOCKDIVISION_DIV1;
  htim14.Init.AutoReloadPreload = TIM_AUTORELOAD_PRELOAD_DISABLE;
  if (HAL_TIM_Base_Init(&htim14) != HAL_OK)
  {
    Error_Handler();
  }
  if (HAL_TIM_PWM_Init(&htim14) != HAL_OK)
  {
    Error_Handler();
  }
  sConfigOC.OCMode = TIM_OCMODE_PWM1;
  sConfigOC.Pulse = 0;
  sConfigOC.OCPolarity = TIM_OCPOLARITY_HIGH;
  sConfigOC.OCFastMode = TIM_OCFAST_DISABLE;
  if (HAL_TIM_PWM_ConfigChannel(&htim14, &sConfigOC, TIM_CHANNEL_1) != HAL_OK)
  {
    Error_Handler();
  }
  /* USER CODE BEGIN TIM14_Init 2 */

  /* USER CODE END TIM14_Init 2 */
  HAL_TIM_MspPostInit(&htim14);

}

/**
  * @brief GPIO Initialization Function
  * @param None
  * @retval None
  */
static void MX_GPIO_Init(void)
{
  GPIO_InitTypeDef GPIO_InitStruct = {0};
  /* USER CODE BEGIN MX_GPIO_Init_1 */
  /* USER CODE END MX_GPIO_Init_1 */

  /* GPIO Ports Clock Enable */
  __HAL_RCC_GPIOF_CLK_ENABLE();
  __HAL_RCC_GPIOA_CLK_ENABLE();

  /*Configure GPIO pin Output Level */
  HAL_GPIO_WritePin(GPIOA, GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3, GPIO_PIN_RESET);

  /*Configure GPIO pins : PA0 PA1 PA2 PA3 */
  GPIO_InitStruct.Pin = GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3;
  GPIO_InitStruct.Mode = GPIO_MODE_OUTPUT_PP;
  GPIO_InitStruct.Pull = GPIO_NOPULL;
  GPIO_InitStruct.Speed = GPIO_SPEED_FREQ_LOW;
  HAL_GPIO_Init(GPIOA, &GPIO_InitStruct);

  /* USER CODE BEGIN MX_GPIO_Init_2 */
  /* USER CODE END MX_GPIO_Init_2 */
}

/* USER CODE BEGIN 4 */

/* USER CODE END 4 */

/**
  * @brief  This function is executed in case of error occurrence.
  * @retval None
  */
void Error_Handler(void)
{
  /* USER CODE BEGIN Error_Handler_Debug */
	__disable_irq();
	while (1) {
	}
  /* USER CODE END Error_Handler_Debug */
}

#ifdef  USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t *file, uint32_t line)
{
  /* USER CODE BEGIN 6 */
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */
  /* USER CODE END 6 */
}
#endif /* USE_FULL_ASSERT */
